/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.client.registry.display;

import java.util.Collections;
import java.util.List;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.SimpleDisplayRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategoryView;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplayMerger;
import me.shedaniel.rei.api.common.util.Identifiable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public interface DisplayCategory<T extends Display>
extends DisplayCategoryView<T>,
Identifiable {
    public CategoryIdentifier<? extends T> getCategoryIdentifier();

    public class_2561 getTitle();

    public Renderer getIcon();

    @Override
    @ApiStatus.OverrideOnly
    default public DisplayRenderer getDisplayRenderer(T display) {
        return SimpleDisplayRenderer.from(display.getInputEntries(), display.getOutputEntries());
    }

    @Override
    @ApiStatus.OverrideOnly
    default public List<Widget> setupDisplay(T display, Rectangle bounds) {
        return Collections.singletonList(Widgets.createRecipeBase(bounds));
    }

    default public int getDisplayHeight() {
        return 66;
    }

    default public int getDisplayWidth(T display) {
        return 150;
    }

    default public int getMaximumDisplaysPerPage() {
        return 99;
    }

    default public int getFixedDisplaysPerPage() {
        return -1;
    }

    @Nullable
    default public DisplayMerger<T> getDisplayMerger() {
        return null;
    }

    public static <T extends Display> DisplayMerger<T> getContentMerger() {
        return new DisplayMerger<T>(){

            @Override
            public boolean canMerge(T first, T second) {
                if (!first.getCategoryIdentifier().equals(second.getCategoryIdentifier())) {
                    return false;
                }
                if (!first.getInputEntries().equals(second.getInputEntries())) {
                    return false;
                }
                return first.getOutputEntries().equals(second.getOutputEntries());
            }

            @Override
            public int hashOf(T display) {
                return display.getCategoryIdentifier().hashCode() * 31 * 31 * 31 + display.getInputEntries().hashCode() * 31 * 31 + display.getOutputEntries().hashCode();
            }
        };
    }

    @Override
    default public class_2960 getIdentifier() {
        return this.getCategoryIdentifier().getIdentifier();
    }
}

